﻿/*	VERSION:	1.4
1.4		"make_cheatCode" is defined in a local-friendly way as:  function make_cheatCode()
1.3		Added support for ↑↓←→ unicode arrows

USAGE:
	code = make_cheatCode("↑↓←→");

	code.rightKey = function(pressed_charCode, match_charCode){
		trace(pressed_charCode+" is correct, so far");
	}// rightKey()
	
	code.wrongKey = function(pressed_charCode, match_charCode){
		trace(pressed_charCode+" is wrong, need "+match_charCode + " ... resetting code to the beginning");
	}// wrongKey()
	
	code.done = function(code_str){
		trace('"'+code_str+'" complete');
	}// done()
	
	onUnload = function(){
		code.onUnload();
	}// onUnload()
*/
function make_cheatCode( code ){
	var output = {};
	var code_str = code.toUpperCase();
	var index = 0;
	
	output.onKeyDown = function(){
		var pressed_charCode = String.fromCharCode( Key.getCode() ).toUpperCase().charCodeAt(0);
		var match_charCode = code_str.charAt(index).toUpperCase().charCodeAt(0);
		// allow ↑↓←→ unicode arrows to represent keyboard arrow keys
		if( match_charCode === 8593)		match_charCode = 38;		// Change ↑ string  =>  up-arrow key-code
		if( match_charCode === 8595)		match_charCode = 40;		// Change ↓ string  =>  down-arrow key-code
		if( match_charCode === 8592)		match_charCode = 37;		// Change ← string  =>  left-arrow key-code
		if( match_charCode === 8594)		match_charCode = 39;		// Change → string  =>  right-arrow key-code
		// compare character-codes
		if(match_charCode === pressed_charCode){
			index++;
			output.rightKey( pressed_charCode, match_charCode );
			if(index == code_str.length){
				index = 0;
				output.done( code );
				Key.removeListener( key_react );
			}// if:  pressed last code character
		}// if:  match
		else
		{// if:  wrong key pressed
			index = 0;
			output.wrongKey( pressed_charCode, match_charCode );
		}// if:  wrong key pressed
	}// onKeyDown()
	Key.addListener( output );
	output.onUnload = function(){
		Key.removeListener( output );
	}// onUnload()
	output.unload = function(){
		Key.removeListener( output );
	}// unload()
	
	return output;
}// make_cheatCode()